<?php

/**
 * Register Google fonts.
 *
 * @return string Google fonts URL for the theme.
 */

function transland_fonts_url() {
    $fonts_url = '';
    $fonts     = array();
    $subsets   = '';

    /* Body font */
    if (  'off' !== 'on'  ) {
        $fonts[] = "Poppins|Roboto:300,400,500,600,700,800";
    }

    $is_ssl = is_ssl() ? 'https' : 'http';

    if ( $fonts ) {
        $fonts_url = add_query_arg( array(
            'family' => urlencode( implode( '|', $fonts  ) ),
            'subset' => urlencode( $subsets ),
        ), "$is_ssl://fonts.googleapis.com/css" );
    }

    return $fonts_url;
}

/**
 * Enqueue scripts and styles.
 */ 
function transland_scripts() {
    $opt = get_option('transland_opt');
    global $post;

	$dynamic_css = '';

    wp_register_style( 'transland-fonts', transland_fonts_url(), array(), null);

    wp_enqueue_style( 'transland-fonts' );

    wp_enqueue_style( 'bootstrap',  TRANSLAND_DIR_CSS.'/bootstrap.min.css' );

    wp_enqueue_style( 'animate',  TRANSLAND_DIR_CSS.'/animate.css' );

    wp_enqueue_style( 'metismenu',  TRANSLAND_DIR_CSS.'/metismenu.css' );

    wp_enqueue_style( 'magnific-popup-css',  TRANSLAND_DIR_CSS.'/magnific-popup.css' );

    wp_enqueue_style( 'slick-css',  TRANSLAND_DIR_CSS.'/slick.css' );

    wp_enqueue_style( 'icons',  TRANSLAND_DIR_CSS.'/icons.css' );
    
    wp_enqueue_style( 'transland-main-style',  TRANSLAND_DIR_CSS . '/style.css', array(), filemtime( get_template_directory().'/assets/css/style.css' ) );

    $theme_version = wp_get_theme()->get( 'Version' );

    wp_enqueue_style( 'transland-style', get_stylesheet_uri(), array(), filemtime( get_template_directory().'/style.css' ) );
	wp_style_add_data( 'transland-style', 'rtl', 'replace' );

    if ( is_rtl() ) {
        wp_enqueue_style( 'transland-rtl', TRANSLAND_DIR_CSS . '/rtl.css' );
    }
    
    if(function_exists('get_field')) {

        $banner_background_type = function_exists('get_field') ? get_field('banner_background_type') : '';

        $background_image = function_exists('get_field') ? get_field('banner_background_image') : '';

        $banner_overlay_color = function_exists('get_field') ? get_field('banner_overlay_color') : '';

        $background_color_left = function_exists('get_field') ? get_field('background_color_left') : '';

        $background_color_right = function_exists('get_field') ? get_field('background_color_right') : '';

        $banner_text_color = function_exists('get_field') ? get_field('banner_text_color') : '';


        if (!empty($background_color_right) && !empty($background_color_left) && $banner_background_type == 'color' ) {
            $dynamic_css .= "
            .page-banner-wrap {
                background-image: linear-gradient(-49deg, " . esc_attr(get_field('background_color_left')) . " 0%,  " . esc_attr(get_field('background_color_right')) . " 100%) !important;
            }
            ";
        }    

        if ( !empty( $background_image ) && !empty( $banner_overlay_color ) && $banner_background_type == 'image' ) {
            $dynamic_css .= "
            .page-banner-wrap {
                background-image: url(". esc_url($background_image) . ") !important;
            }
            .page-banner-wrap::before {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
                height: 100%;
                content: '';
                background: ". esc_attr($banner_overlay_color) .";
                opacity: .7;
            }
            ";
        }

        if ( !empty($banner_text_color) ) {
            $dynamic_css .= "
           .page-banner-wrap h1 {
               color: ". esc_attr($banner_text_color) ." !important;
            }
            ";
        }

        $footer_custom_design_opt = function_exists( 'get_field'  ) ? get_field( 'footer_custom_design_opt'  ) : '';
        $footer_bottom_bar_background_color = function_exists( 'get_field'  ) ? get_field( 'footer_bottom_bar_background_color'  ) : '';
        $footer_bottom_bar_text_color = function_exists( 'get_field'  ) ? get_field( 'footer_bottom_bar_text_color'  ) : '';


        if ( !empty($footer_custom_design_opt) && $footer_custom_design_opt == '1' && !empty($footer_bottom_bar_text_color)  ) {
            $dynamic_css .= "
            .footer-wrap .footer-bottom p, .footer-wrap .footer-bottom a {
                color: {$footer_bottom_bar_text_color} !important;
            }
        ";
        }

        if ( !empty($footer_custom_design_opt) && $footer_custom_design_opt == '1' && !empty($footer_bottom_bar_background_color)  ) {
            $dynamic_css .= "
            .footer-wrap .footer-bottom {
                background-color: {$footer_bottom_bar_background_color} !important;
            }
        ";
        }

    }

    if ( class_exists('ReduxFrameworkPlugin') ) {

        $opt = get_option( 'transland_opt' );

        $is_banner_img = isset( $opt['is_banner_img'] ) ? $opt['is_banner_img'] : '';        

        $header_banner_img = isset( $opt['header_banner_img'] ['url'] ) ? $opt['header_banner_img'] ['url'] : '';

        $banner_color = isset( $opt['banner_color'] ) ? $opt['banner_color']  : '';

        $banner_overlay_color = isset( $opt['banner_overlay_color'] ) ? $opt['banner_overlay_color']  : '';

        $banner_overlay_color_opacity = isset( $opt['banner_overlay_color_opacity'] ) ? $opt['banner_overlay_color_opacity']  : '';

        $scroll_bg_color = isset( $opt['scroll_bg_color'] ) ? $opt['scroll_bg_color'] : '';

        $logo_text_color = isset( $opt['logo_text_color'] ) ? $opt['logo_text_color'] : '';

        $menu_text_color = isset( $opt['menu_text_color'] ) ? $opt['menu_text_color'] : '';
        $menu_hover_text_color = isset( $opt['menu_hover_text_color'] ) ? $opt['menu_hover_text_color'] : '';
        $menu_active_text_color = isset( $opt['menu_active_text_color'] ) ? $opt['menu_active_text_color'] : '';
        $sub_menu_bg_color = isset( $opt['sub_menu_bg_color'] ) ? $opt['sub_menu_bg_color'] : '';
        $menu_item_margin_top = isset( $opt['menu_item_margin']['margin-top'] ) ? $opt['menu_item_margin']['margin-top'] : '';
        $menu_item_margin_left = isset( $opt['menu_item_margin']['margin-left'] ) ? $opt['menu_item_margin']['margin-left'] : '';
        $menu_item_margin_right = isset( $opt['menu_item_margin']['margin-right'] ) ? $opt['menu_item_margin']['margin-right'] : '';
        $menu_item_margin_bottom = isset( $opt['menu_item_margin']['margin-bottom'] ) ? $opt['menu_item_margin']['margin-bottom'] : '';

        $scroll_hover_bg_color = isset( $opt['scroll_hover_bg_color'] ) ? $opt['scroll_hover_bg_color'] : '';
        $preloader_bg = isset( $opt['preloader_bg']['background-color'] ) ? $opt['preloader_bg']['background-color'] : '';
        $menu_btn_size = isset( $opt['menu_btn_size'] ) ? $opt['menu_btn_size'] : '';
        
        $footer_bg_color = isset( $opt['footer_bg_color'] ) ? $opt['footer_bg_color'] : '';
        $widget_title_color = isset( $opt['widget_title_color'] ) ? $opt['widget_title_color'] : '';
        $footer_bg_img = isset( $opt['footer_bg_img']['url'] ) ? $opt['footer_bg_img']['url'] : '';
        $footer_bottom_bg_color = isset( $opt['footer_bottom_bg_color'] ) ? $opt['footer_bottom_bg_color'] : '';

        $theme_first_color = isset( $opt['theme_first_color'] ) ? $opt['theme_first_color'] : '';
        $theme_second_color = isset( $opt['theme_second_color'] ) ? $opt['theme_second_color'] : '';
        $theme_third_color = isset( $opt['theme_third_color'] ) ? $opt['theme_third_color'] : '';
        
        if ( !empty($theme_first_color ) ) {
            $dynamic_css .= "
            .block-contents blockquote,.blocks-gallery-caption,.blog-wrapper form.search-form-box button,.blog-wrapper form.search-form-box input,.breadcrumb-wrapper .breadcrumb .breadcrumb-item a:hover,.calendar_wrap table,.calendar_wrap tfoot td,.calendar_wrap tfoot td a,.comments-item-list a.comment-reply-link:hover,.main-sidebar .author_box_widegts .social-profile a:hover,.main-sidebar .single-sidebar-widget .comment-author-link,.main-sidebar .single-sidebar-widget a,.main-sidebar .single-sidebar-widget ul a,.mobile-nav .social-icons a:hover,.our-services-box .single-service-icon .service-link,.page-links a.post-page-numbers:hover,.page-links a:hover,.popular-posts .single-post-item .post-content .post-date,.popular_posts .single-post-item .post-content .post-date,.preloader .animation-preloader .txt-loading .letters-loading::before,.preloader p,.recent-post-list .single-recent-post .post-data h5:hover,.screen-reader-text:focus,.service-item-card-2 .contents .read-more-link,.single-blog-item .content .post-meta i,.single-news-box .content h3,.single-news-card .contents .post-cat-date .post-cat a,.single-our-service .content h3:hover a,.single-team-member-3 .team-details-bar .member-details .member-data span,.single-team-member-3 .team-details-bar .member-details .social-profile a,.site_info_widget .single-contact-info span,.team-member-card .profile-info-card .social-link a:hover,.team-member-card .profile-info-card h5:hover a,.top-bar-header .search-box form button,.top-bar-header .search-box form input,.top-bar-header .social-links a,.video-btn,.video-play-btn .play-video:hover,.widget select,.widget select:focus,.widget ul li>span.number,.widget.widget_rss .rss-date,.woocommerce div.product p.price,.woocommerce div.product span.price,.wp-block-archives a,.wp-block-categories a,.wp-block-embed figcaption,.wp-block-latest-comments__comment-author,.wp-calendar-table tr td a:hover,.wp-caption-text,figcaption,footer .footer-bottom .social-links a:hover,footer span.wp-calendar-nav-next a:hover,footer span.wp-calendar-nav-prev a:hover,h1,h2,h3,h4,h5,h6,header .logo_text, body header.header-2 .main-menu ul>li:hover>ul li:hover a,header.header-2 .main-menu ul>li>ul li a:hover,header.header-3 #hamburger,header.header-3 .single-menu-box .icon,header.header-3 .top-header .welcome-text a,header.header-5 .links ul li a:hover,header.header-5 .main-menu ul>li:hover>a,header.header-box-style .box-wrap .main-menu ul>li:hover>a,header.header-box-style .box-wrap .main-menu ul>li>a,header.header-box-style .social-link a,header.header-box-style .top-bar a header.header-5 .top-header .header-right-cta .social-profile a:hover,input[type=date],input[type=email],input[type=number],input[type=password],input[type=range],input[type=search],input[type=tel],input[type=text],input[type=url],nav.navigation.comment-navigation .nav-links a,table td a,table th a,textarea {
                color: ". esc_attr($theme_first_color) ." !important;
            }";
        }

        if ( !empty($theme_first_color ) ) {
            $dynamic_css .= "
            .block-contents .section-title h5 {
                -webkit-text-stroke-color: ". esc_attr($theme_first_color) ." !important;
            }";
        }

        if ( !empty($theme_first_color ) ) {
            $dynamic_css .= "
            .theme-btn, #scrollUp,.bg-overlay::before,.blog-post-details .post-navigation .nav-links a,.blog-wrapper .single-blog-post .post-content .post-cat a:hover,.blog-wrapper .single-blog-post.format-quote .post-content,.blog-wrapper .single-blog-post.post-details .wp-block-quote,.blog-wrapper .single-blog-post.post-details blockquote,.blog-wrapper .single-blog-post.quote-post .post-content,.cat-btn.color,.cat-btn:hover,.comment-form .submit:hover,.contact-form .submit-btn.active,.contact-form .submit-btn:hover,.contact-form input[type=submit].active,.contact-form input[type=submit]:hover,.hero-1 .single-slide .slide-bg::after,.hero-1 .single-slide .slide-bg::before,.main-sidebar .single-sidebar-widget .social-link a:hover,.mobile-nav .sidebar-nav .metismenu a:active,.mobile-nav .sidebar-nav .metismenu a:focus,.mobile-nav .sidebar-nav .metismenu a:hover,.page-banner-wrap,.page-banner-wrap::after,.page-banner-wrap::before,.page-nav-wrap ul li .page-numbers.current,.page-nav-wrap ul li .page-numbers:hover,.post-password-form input[type=submit],.request-quote-form-wrapper .request-quote-form .submit-btn,.request-quote-form-wrapper .request-quote-form input[type=submit],.search_widget form button:hover,.single-article-card .content-bottom .read-more-btn:hover,.single-article-card .contents .post-cat a,.single-article-card .thumb,.single-blog-card .blog-details::before,.single-news-card.active::before,.single-news-card:hover::before,.single-team-member-3 .team-details-bar::after,.site_info_widget .single-contact-info:nth-child(2n) .icon,.tag-share-wrap .post-tags a,.theme-bg,.theme-btn.black,.top-bar-wrapper,.woocommerce #respond input#submit.alt,.woocommerce .onsale,.woocommerce .woocommerce-pagination ul.page-numbers li a:hover,.woocommerce .woocommerce-pagination ul.page-numbers li span:hover,.woocommerce .woocommerce-pagination ul.page-numbers li.current,.woocommerce a.button.alt,.woocommerce a.button:hover,.woocommerce button.button.alt,.woocommerce input.button.alt,.wp-calendar-table tbody td#today,button.minus:hover,button.plus:hover,button.wp-block-search__button:hover,footer .footer-bottom,footer .footer-bottom-bar, body header .main-menu-wrapper, body header.header-3 .main-menu ul>li>ul, body header.header-3 .main-menu-wrapper, body header.header-5 .main-menu ul>li>ul,header.header-box-style .box-wrap .main-menu ul>li>a::before,header.header-box-style .top-bar .d-btn,p.sticky-label, body header.header-1 .main-menu ul > li > ul {
                background-color: ". esc_attr($theme_first_color) ." !important;
            }";
        }

        if ( !empty($theme_first_color ) ) {
            $dynamic_css .= "
            body .theme-btn, .blog-wrapper form.search-form-box,.cat-btn:hover,.comments-item-list a.comment-reply-link:hover,.request-quote-form-wrapper .request-quote-form input[type=checkbox],.request-quote-form-wrapper .request-quote-form input[type=radio],.theme-btn.black .cat-btn.color,.wp-calendar-table tbody td#today,blockquote,header.header-box-style .top-bar .d-btn {
                border-color: ". esc_attr($theme_first_color) ." !important;
            }";
        }

        if ( !empty($theme_first_color ) ) {
            $dynamic_css .= "
            .single-our-service .thumb::after {
                background-image:-webkit-gradient(linear,left bottom,left top,from(". esc_attr($theme_first_color) ."),color-stop(65%,rgba(31,66,93,.2)),to(rgba(31,66,93,0)));background-image:linear-gradient(0deg,". esc_attr($theme_first_color) ." 0,rgba(31,66,93,.2) 65%,rgba(31,66,93,0) 100%); !important;
            }";
        }

        if ( !empty($theme_second_color ) ) {
            $dynamic_css .= "
            .block-contents .section-title h2 span,.blog-wrapper .single-blog-post.post-details .wp-block-quote a:hover,.blog-wrapper .single-blog-post.post-details blockquote a:hover,.blog-wrapper form.search-form-box button:hover,.breadcrumb-wrapper,.breadcrumb-wrapper .breadcrumb .breadcrumb-item a,.breadcrumb-wrapper a:hover,.call-us .icon,.comments-item-list .single-comment-item .author-info-comment span,.hero-2 .single-slide .hero-contents h1 span,.main-sidebar .single-sidebar-widget #recentcomments .recentcomments>a,.main-sidebar .single-sidebar-widget .wp-block-latest-comments__comment-link,.newsletter_widget>i,.our-services-box .single-service-icon .icon,.popular-posts .single-post-item .post-content h5:hover,.popular_posts .single-post-item .post-content h5:hover,.preloader .animation-preloader .txt-loading .letters-loading,.service-item-card-2 .contents .read-more-link:hover,.service-item-card-2 .contents h3:hover a,.single-blog-card .blog-details span i,.single-blog-item .content .post-meta .post-author a:hover,.single-blog-item .content h3:hover a,.single-branch-card .content p a,.single-price-bar.active .theme-btn:hover,.single-team-member .member-details h3,.single-team-member .social-icons .plus-icon,.single-team-member .social-icons a,.single-team-member-3 .team-details-bar .member-details .social-profile a:hover,.single-team-member-3 .team-details-bar .plus-btn,.top-bar-header .search-box form button:hover,.top-bar-header .social-links a:hover,.top-bar-wrapper .social-pages a:hover,.top-bar-wrapper .top-left a i,.widget.widget_rss cite,.work-steps-list .single-work-steps .icon::before,footer .footer-bottom-bar a,footer .footer-bottom-bar b,footer .footer-bottom-bar strong,h2.woocommerce-loop-product__title:hover,header.header-1 .main-menu ul>li:hover>a,header.header-2 .main-menu ul>li:hover>a,header.header-5 .main-menu ul>li>ul li a:hover,header.header-box-style .top-bar a i, body header.header-1 .main-menu ul > li > a:hover {
                color: ". esc_attr($theme_second_color) ." !important;
            }";
        } 

        if ( !empty($theme_second_color ) ) {
            $dynamic_css .= "
            body .single-our-service::before {
                background-image:-webkit-gradient(linear,left bottom,left top,from(". esc_attr($theme_second_color) ."),color-stop(65%,rgba(33,30,59,.5)),to(rgba(33,30,59,0)));background-image:linear-gradient(0deg,". esc_attr($theme_second_color) ." 0,rgba(33,30,59,.5) 65%,rgba(33,30,59,0) 100%) !important;
            }";
        }

        if ( !empty($theme_second_color ) ) {
            $dynamic_css .= "
            body .hero-2 .single-slide .hero-contents h1 span {
                -webkit-text-stroke-color: ". esc_attr($theme_second_color) ." !important;
            }";
        }

        if ( !empty($theme_second_color ) ) {
            $dynamic_css .= "
             .service-item-card-2 .icon, #scrollUp:hover,.blog-post-details .post-navigation .nav-links a:hover,.blog-wrapper .single-blog-post .post-content .post-cat a,.comment-form .submit,.contact-form .submit-btn,.contact-form input[type=submit],.core-features-carousel .slick-arrow:hover,.hero-2 .single-slide .hero-contents a:hover,.newsletter_widget button,.newsletter_widget input[type=submit],.our-services-box .single-service-icon.active,.our-services-box .single-service-icon::after .work-steps-list .single-work-steps .icon::before,.our-services-box .single-service-icon::before,.our-services-box .single-service-icon:hover,.page-links a.post-page-numbers,.post-password-form input[type=submit],.request-quote-form-wrapper .request-quote-form .submit-btn:hover,.request-quote-form-wrapper .request-quote-form input[type=submit]:hover,.search_widget form button,.service-item-card-2 .icon,.services-carousel-nav-next:hover,.services-carousel-nav-prev:hover,.single-article-card .content-bottom .read-more-btn,.single-article-card .content-bottom::before,.single-article-card .contents .post-cat a:hover,.single-blog-card .cat-name:hover,.single-blog-item .post-featured-thumb .post-cat a:hover,.single-news-box .featured-thumb .post-cat a:hover,.single-price-bar.active,.single-progress-bar .progress .progress-bar,.single-team-member .member-details span,.single-team-member .social-icons .plus-icon:hover,.single-team-member .social-icons a:hover,.single-team-member-3 .team-details-bar .plus-btn:hover,.single-testimonial-card .client-img::before,.site_info_widget .single-contact-info:nth-child(3n) .icon,.slide-dots li button:hover,.slide-dots li.slick-active button,.tag-share-wrap .post-tags a:hover,.tagcloud a:hover,.theme-btn:hover,.theme-btn.black:hover,.theme-btn.no-fil:hover,.widget.widget_tag_cloud .tagcloud a,.widget_rss li cite:before,.woocommerce #respond input#submit.alt:hover,.woocommerce a.button.alt:hover,.woocommerce button.button.alt:hover,.woocommerce input.button.alt:hover,.wp-block-search .wp-block-search__button,form.search-form .search-submit, body header.header-2 .main-menu ul>li>a::before,header.header-2 .main-menu ul>li>ul,header.header-3 .top-header,header.header-box-style .box-wrap .main-menu ul>li>ul, body .theme-btn:hover {
                background-color: ". esc_attr($theme_second_color) ." !important;
            }";
        }

        if ( !empty($theme_second_color ) ) {
            $dynamic_css .= "
            body .theme-btn:hover, .block-contents blockquote,.core-features-carousel .slick-arrow:hover,.hero-2 .single-slide .hero-contents a:hover,.single-price-bar.active,.single-team-member-3 .team-details-bar .plus-btn,.slide-dots li button,.slide-dots li.slick-active button,.theme-btn.black:hover,.theme-btn.no-fil:hover,.work-steps-list .single-work-steps .icon::before {
                border-color: ". esc_attr($theme_second_color) ." !important;
            }";
        }

        if ( !empty($theme_third_color ) ) {
            $dynamic_css .= "
            .block-contents .section-title>span,.blog-wrapper .single-blog-post h2:hover a,.calendar_wrap tfoot td a:hover,.core-features-carousel .single-features-item .icon,.main-sidebar .single-sidebar-widget .comment-author-link:hover,.main-sidebar .single-sidebar-widget a:hover,.main-sidebar .single-sidebar-widget ul a:hover,.our-services-box .single-service-icon .service-link:hover,.section-title-2 span,.single-article-card .contents h3:hover a,.single-blog-card .blog-details h3:hover a .hero-1 .single-slide .hero-contents h1 span,.single-blog-card .post-content h3:hover a,.single-branch-card .content .branch-links a:hover,.single-info-element .icon,.single-news-box .content .read-btn,.single-news-box .content .read-btn:hover,.single-news-box .content h3 a:hover,.single-news-card .contents .post-cat-date .post-cat a:hover,.single-news-card .contents h5:hover a .single-news-card .contents .post-cat-date .post-date,.single-testimonial-card .feedback .star,.video-play-btn .play-video,.wp-block-archives a:hover,.wp-block-categories a:hover,.wp-block-latest-comments__comment-author:hover,header.header-3 .main-menu ul>li:hover>a,header.header-3 .main-menu ul>li>ul li a:hover,header.header-box-style .top-bar a:hover {
                color: ". esc_attr($theme_third_color) ." !important;
            }";
        }

        if ( !empty($theme_third_color ) ) {
            $dynamic_css .= "
            .block-contents .section-title>span::before,.hero-1 .slide-pop-video-box-wrapper,.hero-2 .single-slide .hero-contents a,.services-carousel-nav-next,.services-carousel-nav-prev,.single-blog-card .cat-name,.single-blog-item .post-featured-thumb .post-cat a,.single-news-box .featured-thumb .post-cat a,.single-price-bar .theme-btn:hover,.team-member-card .profile-info-card .single-team-member .social-icons:hover .plus-icon,footer .footer-bottom .bottom-content-wrapper,header.header-box-style .top-bar .d-btn:hover {
                background-color: ". esc_attr($theme_third_color) ." !important;
            }";
        }

        if ( !empty($theme_third_color ) ) {
            $dynamic_css .= "
            .hero-2 .single-slide .hero-contents a,.single-price-bar .theme-btn:hover,header.header-box-style .top-bar .d-btn:hover {
                border-color: ". esc_attr($theme_third_color) ." !important;
            }";
        }

        if ( !empty($theme_third_color ) ) {
            $dynamic_css .= "
            .section-title-2 span {
                -webkit-text-stroke-color: ". esc_attr($theme_third_color) ." !important;
            }";
        }

        // pre-loader setting
        if ( !empty($preloader_bg ) ) {
            $dynamic_css .= "
            .preloader .loader .loader-section .bg {
                background-color: ". esc_attr($preloader_bg) .";
            }";
        }

        if ( !empty($footer_bg_color ) ) {
            $dynamic_css .= "
            footer .footer-widgets-wrapper {
                background-color: ". esc_attr($footer_bg_color) ." !important;
            }";
        } 

        if ( !empty( $footer_bg_img ) ) {
            $dynamic_css .= "
            footer .footer-widgets-wrapper {
                background-image: url(". esc_url($footer_bg_img) .");
            }";
        } 

        if ( !empty($widget_title_color ) ) {
            $dynamic_css .= "
            footer .single-footer-wid .wid-title h6 {
                color: ". esc_attr($widget_title_color) .";
            }";
        } 

        if ( !empty($menu_btn_size) ) {
            $dynamic_css .= "
            header a.theme-btn {
               font-size: ". esc_attr($menu_btn_size) ."px;
            }
            ";
        }

        if ( !empty($menu_text_color ) ) {
            $dynamic_css .= "
            header .main-menu ul li a {
                color: ". esc_attr($menu_text_color) ." !important;
            }";
        } 

        if ( !empty($menu_hover_text_color ) ) {
            $dynamic_css .= "
            header .main-menu ul li:hover a {
                color: ". esc_attr($menu_hover_text_color) ." !important;
            }";
        } 

        if ( !empty($menu_active_text_color ) ) {
            $dynamic_css .= "
            header .main-menu ul li.current-menu-item  a {
                color: ". esc_attr($menu_active_text_color) ." !important;
            }";
        } 

        if ( !empty($menu_item_margin_top ) || !empty($menu_item_margin_right ) ) {
            $dynamic_css .= "
            header .main-menu ul li {
                margin: ". esc_attr($menu_item_margin_top) ." ". esc_attr($menu_item_margin_right) ." ". esc_attr($menu_item_margin_bottom) ." ". esc_attr($menu_item_margin_left) ." !important;
            }";
        } 

        if ( !empty($sub_menu_bg_color ) ) {
            $dynamic_css .= "
            header .main-menu ul li ul {
                background: ". esc_attr($sub_menu_bg_color) ." !important;
            }";
        } 

        if ( !empty($footer_bottom_bg_color ) ) {
            $dynamic_css .= "
            footer .footer-bottom {
                background-color: ". esc_attr($footer_bottom_bg_color) ."  !important;
            }";
        } 

        if ( !empty($header_banner_img && $is_banner_img == '1' ) ) {
            $dynamic_css .= "
            .page-banner-wrap {
                background-image: url(". esc_url($header_banner_img) .");
            }";
        } 

        if ( !empty($banner_overlay_color) && $is_banner_img == '1' ) {
            $dynamic_css .= "
            .page-banner-wrap::before {
                background: ". esc_attr($banner_overlay_color) .";                
            }";
        } 

        if ( !empty($banner_overlay_color_opacity) && $is_banner_img == '1' ) {
            $dynamic_css .= "
            .page-banner-wrap::before {                
                opacity: ". esc_attr($banner_overlay_color_opacity) .";
            }";
        } 

        if ( !empty($banner_color && $is_banner_img == '0' ) ) {
            $dynamic_css .= "
            .page-banner-wrap {
                background: ". esc_attr($banner_color) ." !important;
            }";
        } 

        if ( !empty($logo_text_color ) ) {
            $dynamic_css .= "
            .logo h3 {
                color: ". esc_attr($logo_text_color) ." !important;
            }";
        } 

        if ( !empty($scroll_bg_color ) ) {
            $dynamic_css .= "
            .scroll-up {
                background-color: ". esc_attr($scroll_bg_color) .";
            }";
        } 

        if ( !empty($scroll_hover_bg_color ) ) {
            $dynamic_css .= "
            .scroll-up:hover {
                background-color: ". esc_attr($scroll_hover_bg_color) .";
            }";
        }
    }

    wp_add_inline_style( 'transland-style', $dynamic_css );

    $dynamic_js = '';
    
    wp_enqueue_script( 'popper', TRANSLAND_DIR_JS.'/popper.min.js', array('jquery'), '1.0', true );

    wp_enqueue_script( 'bootstrap-main', TRANSLAND_DIR_JS.'/bootstrap.min.js', array('jquery'), '4.3.1', true );

    wp_enqueue_script( 'modernizr', TRANSLAND_DIR_JS.'/modernizr.js', array('jquery'), '3.1', true );
    
    wp_enqueue_script('jquery-effects-core');

    wp_enqueue_script( 'easings', TRANSLAND_DIR_JS.'/jquery.easing.js', array('jquery'), '1.3', true );

    wp_enqueue_script( 'imagesloaded' );

    wp_enqueue_script( 'navigation-js', TRANSLAND_DIR_JS.'/navigation.js', array('jquery'), '1.3', true );

    wp_enqueue_script( 'wow', TRANSLAND_DIR_JS.'/wow.min.js', array('jquery'), '1.3', true );

    wp_enqueue_script( 'slick', TRANSLAND_DIR_JS.'/slick.min.js', array('jquery'), '2.0', true );
    
    wp_enqueue_script( 'slick-animate', TRANSLAND_DIR_JS.'/slick-animation.min.js', array('jquery'), '0.3', true );

    wp_enqueue_script( 'counterup-js', TRANSLAND_DIR_JS.'/counterup.min.js', array('jquery'), '2.0', true );

    wp_enqueue_script( 'magnific-popup', TRANSLAND_DIR_JS.'/magnific-popup.min.js', array('jquery'), '2.0', true );

    wp_enqueue_script( 'scrollup', TRANSLAND_DIR_JS.'/scrollup.min.js', array('jquery'), '2.4', true );
    
    wp_enqueue_script( 'metismenu', TRANSLAND_DIR_JS.'/metismenu.js', array('jquery'), '2.0', true );  

    wp_enqueue_script( 'transland-active', TRANSLAND_DIR_JS.'/active.js', array('jquery'), filemtime( get_template_directory().'/assets/js/active.js' ), true );

    if ( class_exists( 'ReduxFrameworkPlugin' ) ) {
        $opt = get_option( 'transland_opt' );
    }

    wp_localize_script( 'transland-custom-wp', 'local_strings', array(
        'ajax_url' => admin_url( 'admin-ajax.php' )
    ));

    wp_add_inline_script('transland-custom-wp', $dynamic_js);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}

}

add_action( 'wp_enqueue_scripts', 'transland_scripts' );

add_action('admin_enqueue_scripts', function() {
    wp_enqueue_style('transland-admin', TRANSLAND_DIR_CSS.'/transland-admin.css');
});
