<?php
namespace ModinaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Modina_services extends Widget_Base {

    public function get_name() {
        return 'modina_services';
    }

    public function get_title() {
        return esc_html__( 'Our Services - Carousel', 'modina-core' );
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_keywords() {
        return [ 'service', 'transport', 'freight', 'our', 'carousel', 'delivery', 'modina'];
    }

    public function get_categories() {
        return [ 'modina-elements' ];
    }

    protected function register_controls() {

        // ----- service Item Box ---------//
        $this->start_controls_section(
            'services_section',
            [
                'label' => esc_html__( 'Freight Service', 'modina-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'service_bg',
            [
                'label' => esc_html__( 'Image', 'modina-core' ),
                'type' =>Controls_Manager::MEDIA,
                'default' => [
                    'url' => plugin_dir_url( __DIR__ ).'assets/img/air.jpg',
                ],              
            ]
        );

        $repeater->add_control(
            'service_title',
            [
                'label' => esc_html__( 'Service Title', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Air Freight',
            ]
        );

        $repeater->add_control(
            'service_info',
            [
                'label' => esc_html__( 'Service Info', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => 'As a leader in global air freight forwarding, OIA Global excels in providing tailored transportation',
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'modina-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'modina-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $this->add_control(
            'service_items',
            [
                'label' => esc_html__( 'All Freight Services', 'modina-core' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'service_title'   => 'Air Freight',
                    ],
                    [
                        'service_title'   => 'Ocean Freight',
                    ],
                    [
                        'service_title'   => 'Road Freight',
                    ],
                    [
                        'service_title'   => 'Warehousing',
                    ],
                    [
                        'service_title'   => 'Drone Freight',
                    ],
                ],
                'title_field' => '{{{service_title}}}'
            ]
        );

        $this->end_controls_section();        

        $this->start_controls_section(
            'style_service_item', [
                'label' => esc_html__( 'Service Item Style', 'modina-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            's_color_title', [
                'label' => esc_html__( 'Service Name Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-service-card h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            's_item_margin', [
                'label' => esc_html__( 'Service Item Margin', 'modina-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
                'selectors' => [
                    '{{WRAPPER}} .single-service-card' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ],
                'default' => [
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_service_title',
                'selector' => '{{WRAPPER}} .single-service-card h3',
            ]
        );

        $this->end_controls_section();
        

    }

    protected function render() {

    $settings = $this->get_settings();
    $service_items = $settings['service_items'];
    ?>
        <div class="services-carousel-active">
        <?php
            if (!empty($service_items)) { $i = 0;
            foreach ($service_items as $item) {
            $i++; ?>  
            <div class="single-service-card">
                <div class="service-banner-img bg-cover" style="background-image: url('<?php echo esc_url($item['service_bg']['url']); ?>')"></div>
                <div class="content">
                    <?php if(!empty($item['service_title'])) : ?>
                    <h3><a href="<?php echo esc_url($item['btn_link']['url']); ?> <?php modina_is_external($item['btn_link']); ?> <?php modina_is_nofollow($item['btn_link']); ?>"><?php echo esc_html($item['service_title']) ?></a></h3>
                    <?php endif; ?>
                    <?php if(!empty($item['service_info'])) : ?>
                    <p><?php echo esc_html($item['service_info']) ?></p>
                    <?php endif; ?>
                </div>
            </div>
            <?php } 
        } ?>
        </div>

        <script>
            (function ( $ ) {
                "use strict";
                $(document).ready( function() {
                    if($('.services-carousel-active').length > 0) {
                        $('.services-carousel-active').slick({
                            infinite: false,
                            slidesToShow: 4, 
                            slidesToScroll: 3, 
                            arrows: true,
                            speed: 800,
                            prevArrow: $('.services-carousel-nav-prev'),
                            nextArrow: $('.services-carousel-nav-next'),
                            responsive: [
                                {
                                breakpoint: 1600,
                                settings: {
                                    slidesToShow: 3
                                }
                                },
                                {
                                breakpoint: 1191,
                                settings: {
                                    slidesToShow: 2
                                }
                                },
                                {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    center: true,
                                }
                                },
                                {
                                breakpoint: 480,
                                settings: {
                                    slidesToShow: 1
                                }
                                }
                            ],

                        });
                    }
                });
            }( jQuery ));
        </script>
    <?php
    }
}