<?php
namespace ModinaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;


// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Modina_service_promo_box extends Widget_Base {

    public function get_name() {
        return 'modina_service_promo_box';
    }

    public function get_title() {
        return esc_html__( 'Services Promo Box', 'modina-core' );
    }

    public function get_icon() {
        return 'eicon-icon-box';
    }

    public function get_keywords() {
        return [ 'freight', 'service', 'box', 'transport', 'modina'];
    }

    public function get_categories() {
        return [ 'modina-elements' ];
    }

    protected function register_controls() {

        // ----- service Item Box ---------//
        $this->start_controls_section(
            'box_section',
            [
                'label' => esc_html__( 'Service Item', 'modina-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'icon_type',
            [
                'label' => __( 'Icon Type', 'modina-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'fontawesome' => esc_html__( ' Font-Awesome', 'modina-core' ),
                    'flaticon' => esc_html__( 'Flaticon', 'modina-core' ),
                ],
                'default' => 'flaticon',
            ]
        );

        $repeater->add_control(
            'fontawesome',
            [
                'label' => __( 'Font-Awesome', 'modina-core' ),
                'type' => Controls_Manager::ICON,
                'label_block' => true,
                'condition' => [
                    'icon_type' => 'fontawesome'
                ]
            ]
        );

        $repeater->add_control(
            'flaticon',
            [
                'label'      => __( 'Flaticon', 'modina-core' ),
                'type'       => Controls_Manager::ICON,
                'options'    => modina_flaticons(),
                'include'    => modina_include_flaticons(),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'service_title',
            [
                'label' => esc_html__( 'Title', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'Road freight',
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Service Link', 'modina-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'modina-core' ),
                'default' => [
                    'url' => '#',
                    'is_external' => true,
					'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'services_items',
            [
                'label' => esc_html__( 'All Service Box', 'modina-core' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [                       
                        'service_title'   => 'Road Freight',
                    ],
                ],
                'title_field' => '{{{service_title}}}'
            ]
        );

        $this->end_controls_section();        

        $this->start_controls_section(
            'style_service_item', [
                'label' => esc_html__( 'Services Item Style', 'modina-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            's_color_title', [
                'label' => esc_html__( 'Name Color', 'modina-core' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .single-service-icon h3' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(), [
                'name' => 'typography_service_title',
                'selector' => '{{WRAPPER}} .single-service-icon h3',
            ]
        );

        $this->end_controls_section();
        

    }

    protected function render() {

    $settings = $this->get_settings();
    $services_items = $settings['services_items'];

    ?>
        <div class="our-services-box">
            <div class="row no-padding align-items-center">
            <?php
            if (!empty($services_items)) { $i = 0;
            foreach ($services_items as $item) {
            $i++;
            
            switch ( $item['icon_type'] ) {
                case 'fontawesome':
                    $icon = !empty($item['fontawesome']) ? $item['fontawesome'] : '';
                    break;
                case 'flaticon':
                    $icon = !empty($item['flaticon']) ? $item['flaticon'] : '';
                    break;
            }
            
            ?>
                <div class="col-sm-6 col-12 border-right col-md-4 col-xl-2">
                    <div class="single-service-icon icon<?php echo esc_attr( $i ); ?>">
                        <div class="content">
                            <?php if(!empty($icon)) : ?>
                            <div class="icon">
                                <i class="<?php echo esc_attr( $icon ); ?>"></i>
                            </div>
                            <?php endif; ?>
                            <?php if(!empty($item['service_title'])) : ?>
                            <div class="title">
                                <h6><a href="<?php echo esc_url($item['btn_link']['url']); ?>" <?php modina_is_external($item['btn_link']); ?> <?php modina_is_nofollow($item['btn_link']); ?>><?php echo esc_html($item['service_title']); ?></a></h6>
                            </div>
                            <?php endif; ?>
                        </div>
                        <a href="<?php echo esc_url($item['btn_link']['url']); ?>" <?php modina_is_external($item['btn_link']); ?> <?php modina_is_nofollow($item['btn_link']); ?> class="service-link"><i class="fal fa-long-arrow-right"></i></a>
                    </div>
                </div>
                <?php } 
            } ?>
            </div>
        </div>
    <?php
    }
}