<?php

namespace ModinaCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Background;

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}


class Modina_pricing_bar extends Widget_Base
{

    public function get_name()
    {
        return 'modina_pricing_bar';
    }

    public function get_title()
    {
        return esc_html__('Pricing Bars', 'modina-core');
    }

    public function get_icon()
    {
        return 'eicon-price-table';
    }

    public function get_keywords()
    {
        return ['price', 'table', 'package', 'bar', 'modina'];
    }

    public function get_categories() {
        return [ 'modina-elements' ];
    }

    protected function register_controls() {


         // -------------------  Title Section  -----------------------//
        $this->start_controls_section(
            'section_contents',
            [
                'label' => esc_html__( 'Package - Pricing Bars', 'modina-core' ),
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'package_name', [
                'label' => esc_html__( 'Package Name', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'package_features',
            [
                'label' => esc_html__( 'Package Features', 'modina-core' ),
                'type' => Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => '<span>Custom Business Rules</span> <span>1 Warehouse</span>',
            ]
        );

        $repeater->add_control(
            'package_price',
            [
                'label' => esc_html__( 'Package Price - Value', 'modina-core' ),
                'type' => Controls_Manager::NUMBER,
                'label_block' => true,
                'default' => '49',
            ]
        );

        $repeater->add_control(
            'currency',
            [
                'label' => __( 'Currency', 'modina-core' ),
                'type' => \Elementor\Controls_Manager::SELECT,
                'label_block' => true,
                'default' => 'usd',
                'options' => [
                    'usd'  => __( 'USD', 'modina-core' ),
                    'euro'  => __( 'Euro', 'modina-core' ),
                    'pound'  => __( 'Pound', 'modina-core' ),
                    'pound'  => __( 'Pound', 'modina-core' ),
                ],
            ]
        );
        
        $repeater->add_control(
            'button_text',
            [
                'label' => esc_html__( 'Button Text', 'modina-core' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'default' => 'get started',                
            ]
        );

        $repeater->add_control(
            'btn_link',
            [
                'label' => esc_html__( 'Button Link', 'modina-core' ),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'placeholder' => __( 'https://', 'modina-core' ),
                'default' => [
                    'url' => '#',
                ],
            ]
        );

        $repeater->add_control(
            'active',
            [
                'label' => __( 'Package Bar Active?', 'modina-core' ),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'modina-core' ),
                'label_off' => __( 'No', 'modina-core' ),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'all_package',
            [
                'label' => esc_html__( 'All Packages', 'modina-core' ),
                'type' =>Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'package_name'   => 'Solar Panel Installation',
                    ],
                ],
                'title_field' => '{{{package_name}}}'
            ]
        );

        $this->end_controls_section(); 

    }

    protected function render() {

    $settings = $this->get_settings();
    $all_package = $settings['all_package'];
    ?>
    
    <?php if (!empty($all_package)) { $i = 0;
        foreach ($all_package as $item) { $i++; ?>

        <div class="single-price-bar <?php if( !empty( $item['active'] ) && $item['active'] == 'yes' ) : ?> active <?php endif; ?>">
            <div class="row align-items-center">
                <div class="col-xl-2">
                    <?php if( !empty($item['package_name'] ) ) : ?>
                    <div class="package-name">
                        <h3><?php echo htmlspecialchars_decode(esc_html($item['package_name'])); ?></h3>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-5 pe-xl-0">
                    <?php if( !empty($item['package_features'] ) ) : ?>
                    <div class="package-features">
                        <?php echo htmlspecialchars_decode(esc_html($item['package_features'])); ?>
                    </div>
                    <?php endif; ?>
                </div>
                <div class="col-xl-2">
                    <div class="package-price">
                        <h2 class="text-uppercase d-inline-block"><span><?php echo htmlspecialchars_decode(esc_html($item['package_price'])); ?></span></h2>
                        <?php echo htmlspecialchars_decode(esc_html($item['currency'])); ?>
                    </div>
                </div>
                <?php if( !empty( $item['btn_link']['url'] && $item['button_text'] ) ) : ?>
                <div class="col-xl-3 text-xl-end">
                    <a href="<?php echo esc_url($item['btn_link']['url']); ?>" <?php modina_is_external($item['btn_link']); ?> <?php modina_is_nofollow($item['btn_link']); ?> class="theme-btn minimal-btn"><?php echo esc_html( $item['button_text'] ); ?> <i class="fal fa-long-arrow-right"></i></a>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php }
    } ?>
<?php
    }
}
